<?php

/**
 * Add submenu in woocommerce menu
 */
add_action('admin_menu','pod_reo_add_wc_submenu');

function pod_reo_add_wc_submenu(){

    add_submenu_page( 'woocommerce' , __('Rafasshop Export Order','wc_reo') , __('Rafasshop Export Order','wc_reo') , 'manage_options' , 'pod-reo' , 'pod_reo_setting_page_fn' , 2 );//change position of menu by last perameter

    add_action('admin_init','pod_reo_option_create_fn');

}




/**
 * create setting options
 */
function pod_reo_option_create_fn(){
    // register_setting('my_order_status', 'my_status_customer_id','sanitize_option_fn');
    register_setting('my_order_status', 'my_status_customer_id','sanitize_customer_id_function');
    register_setting('my_order_status', 'my_status_start_date','sanitize_start_date_function');
    register_setting('my_order_status', 'my_status_select_status','sanitize_select_status_function');
    register_setting('my_order_status', 'my_status_automatic_apply_message');
    register_setting('my_order_status', 'necklabel');
    register_setting('my_order_status', 'necklabel_image_url','sanitize_necklabel_image_url_function');
    
    register_setting('my_order_status', 'product_sku_as_rafasshop');
    register_setting('my_order_status', 'custom_message_for_packing_list');    
    register_setting('my_order_status', 'rafasshop_product_selection');

    register_setting('my_order_status', 'rafasshop_design_top_position_front', array('type' => 'number'));
    register_setting('my_order_status', 'rafasshop_design_top_position_back', array('type' => 'number'));
    register_setting('my_order_status', 'rafasshop_default_printing_methods');


    
    add_settings_section('general_section' , __('General Settings','wc_reo') , '' ,'pod-reo');
    add_settings_section('distance_section' , __('Printing Distance','wc_reo') , '' ,'pod-reo-distance-section');
    add_settings_section('printing_method_section' , __('PRINTING METHOD','wc_reo') , '' ,'pod-reo-printing-method-section');

    add_settings_field( 'my_status_customer_id' , __('Customer ID<em class="rafasshop-required">*</em>','wc_reo') , 'my_status_customer_id_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'my_status_start_date' , __('Start Date<em class="rafasshop-required">*</em>','wc_reo') , 'my_status_start_date_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'my_status_select_status' , __('Select Status<em class="rafasshop-required">*</em>','wc_reo') , 'my_status_select_status_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'my_status_automatic_apply_message' , __('Automatic Apply order to Marked to send','wc_reo') , 'my_status_automatic_apply_message_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'necklabel' , __('Replace neck label with by brand label(you will be charged with an extra fee)(yes/no)','wc_reo') , 'necklabel_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'necklabel_image_url' , __('We will use this image as your necklabel logo for all products. If you want different label in each product, please, add it in each variation option.(Print custom necklabel cost: 1.95€)(Allowed filetype: PNG)<em class="rafasshop-required">*</em>','wc_reo') , 'necklabel_image_fn', 'pod-reo' , 'general_section', array( 'class' => 'necklabel-image' ));

    add_settings_field( 'product_sku_as_rafasshop' , __('Use product SKU as Rafasshop SKU (must match the introduced SKU in each variation, with the Rafasshop provided SKU)','wc_reo') , 'product_sku_as_rafasshop_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'custom_message_for_packing_list' , __('Custom message to add on packing list (max. 30 words)','wc_reo') , 'custom_message_for_packing_list_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'rafasshop_product_selection' , __('Select your product type','wc_reo') , 'rafasshop_product_selection_fn', 'pod-reo' , 'general_section');

    add_settings_field( 'rafasshop_design_top_position_front' , __('Distance to start printing from top in front side (cm)','wc_reo') , 'rafasshop_design_top_position_front_fn', 'pod-reo-distance-section' , 'distance_section');

    add_settings_field( 'rafasshop_design_top_position_back' , __('Distance to start printing from top in back side (cm)','wc_reo') , 'rafasshop_design_top_position_back_fn', 'pod-reo-distance-section' , 'distance_section');

    add_settings_field( 'rafasshop_default_printing_methods' , __('Please, select the default printing method:','wc_reo') , 'rafasshop_default_printing_methods_fn', 'pod-reo-printing-method-section' , 'printing_method_section');

}



function my_status_customer_id_fn(){
    $option = get_option('my_status_customer_id') ? get_option('my_status_customer_id') : "";
    ?>
    <input type="text" id="my_status_customer_id" name="my_status_customer_id" value="<?php echo $option; ?>" onpaste="return false" autocomplete="off">
    <?php
}


function my_status_start_date_fn(){
    $option = get_option('my_status_start_date') ? get_option('my_status_start_date') : "";    
    ?>
    <input type="date" name="my_status_start_date" value=<?php echo $option; ?> >
    <?php
}


function my_status_select_status_fn(){
    $my_default_status = wc_get_order_statuses();

    ?>
    <select class="js-example-basic-multiple" name="my_status_select_status[]" multiple="multiple">
        <?php

            $option_status = get_option('my_status_select_status');

            foreach($my_default_status as $status=>$value){
            ?>
            <option value="<?php echo $status?>" <?php if($option_status){ if( in_array($status,$option_status) ) echo "selected"; }?> ><?php echo $value; ?></option>

            <?php
            }
            ?>
        </select>
    <?php
}



function my_status_automatic_apply_message_fn(){
    ?>
    <input type="checkbox" name="my_status_automatic_apply_message" value=1 <?php checked( get_option('my_status_automatic_apply_message'), 1 ); ?> >
    <?php
}

function necklabel_fn(){
    ?>
    <input type="checkbox" id="necklabel" name="necklabel" value=1 <?php checked( get_option('necklabel'), 1 ); ?> >
    <?php
}

function necklabel_image_fn(){
    $necklabel_url = get_option('necklabel_image_url') ? get_option('necklabel_image_url') : "";
    ?>
    <button id="set_necklabel_image"><?php _e('Necklabel Image','wc_reo'); ?></button>
    <img src="<?php echo $necklabel_url; ?>" alt="" width="100" id="preview-necklabel-image" />
    <?php
    if($necklabel_url){
        echo '<a href="javascript:void(0)" class="remove-general-necklabel-media">remove</a>';
    }
    ?>
    <input type="hidden" id="necklabel_image_url" name="necklabel_image_url" value="<?php echo $necklabel_url; ?>"  />
    <span class='rafasshop-required' id='necklabel-image-error' style='display:none'><?php _e('please select .png image file.','wc_reo'); ?></span>
    <?php
}


function product_sku_as_rafasshop_fn(){
    ?>
    <input type="checkbox" name="product_sku_as_rafasshop" value=1 <?php checked( get_option('product_sku_as_rafasshop'), 1 ); ?> >
    <?php
}

function custom_message_for_packing_list_fn(){
    ?>
    <textarea name="custom_message_for_packing_list" id="word_count" onpaste="return false"><?php echo get_option('custom_message_for_packing_list'); ?></textarea>
    <span id="display_count">30 words left</span>
    <?php    
}

function rafasshop_product_selection_fn(){
    if(get_option('rafasshop_product_selection') == 'rafasshop_product'){
        $style = 'style="display:none"';
    }
    else{
        $style = '';
    }
    ?>
    <input type="radio" id="rafasshop_product" name="rafasshop_product_selection" value="rafasshop_product" <?php checked( get_option('rafasshop_product_selection'), 'rafasshop_product' ); ?>>
    <label for="rafasshop_product"><?php _e('I use only Rafasshop for all received orders','wc_reo');?></label><br>
    <input type="radio" id="other_providers" name="rafasshop_product_selection" value="other_providers" <?php checked( get_option('rafasshop_product_selection'), 'other_providers' ); ?>>
    <label for="other_providers"><?php _e('I have products from differents providers','wc_reo');?></label>
    <span id="product-selection-msg" class="rafasshop-required" <?php echo $style;?>>
        <?php _e('In order to avoid to send us orders with products that we don\'t provide you, please, you must select in each product variation the check box "Rafasshop product"','wc_reo');?>
    </span>
    <?php    
}

/*
 * @params 
 * Added on 2022-05-23
 */
function rafasshop_design_top_position_front_fn(){
    $option = get_option('rafasshop_design_top_position_front') ? get_option('rafasshop_design_top_position_front') : '';
    ?>
    <input type="number" id="rafasshop_design_top_position_front" name="rafasshop_design_top_position_front" placeholder="0" value="<?php echo $option; ?>" onpaste="return false" autocomplete="off" min="0" max="99">
    <?php
}

function rafasshop_design_top_position_back_fn(){
    $option = get_option('rafasshop_design_top_position_back') ? get_option('rafasshop_design_top_position_back') : '';
    ?>
    <input type="number" id="rafasshop_design_top_position_back" name="rafasshop_design_top_position_back" placeholder="0" value="<?php echo $option; ?>" onpaste="return false" autocomplete="off" min="0" max="99">
    <?php
}

function rafasshop_default_printing_methods_fn(){
    
    $default_printing_status = rafasshopDefaultPrintingMethods();
    unset($default_printing_status['']);
    ?>
    <select name="rafasshop_default_printing_methods">
        <?php

            $option_status = get_option('rafasshop_default_printing_methods');

            foreach($default_printing_status as $key => $status){
            ?>
            <option value="<?php echo $key; ?>" <?php if($option_status){ if( $key == $option_status ) echo "selected"; }?> ><?php echo $status; ?></option>

            <?php
            }
            ?>
        </select>
    <?php
}

// Sanitize all the required fields.
function sanitize_customer_id_function($value){
    if($value==""){
        add_settings_error('my_status_customer_id','my_status_customer_id_error',__('customer id is required.','wc_reo'),'error');
        return false;
    }
    elseif(sanitize_text_field($value) == ''){
        add_settings_error('my_status_customer_id','my_status_customer_id_error',__('Enter valid cuatomer id.','wc_reo'),'error');
        return false;
    }
    return $value;
}


function sanitize_start_date_function($value){
    if($value==""){
        add_settings_error('my_status_start_date','my_status_start_date_error',__('start date is required.','wc_reo'),'error');
        return false;

    }
    return $value;
}

function sanitize_select_status_function($value){
    if($value==""){
        add_settings_error('my_status_select_status','my_status_select_status_error',__('select status is required.','wc_reo'),'error');
        return false;
    }
    return $value;
}

function sanitize_necklabel_image_url_function($value){
    $is_nacklabel = get_option('necklabel');
    if($is_nacklabel == 1 && $value==""){
        add_settings_error('necklabel_image_url','necklabel_image_url_error',__('Nacklabel image is required','wc_reo'),'error');
        return false;
    }
    return $value;
}



/**
 * Display options in table format
 */
function pod_reo_setting_page_fn(){
    // $my_default_status = wc_get_order_statuses();
?>
    <div class="wrap rafasshop_options">
        <h2><?php _e('Rafasshop Export Order', 'wc_reo'); ?></h2>
        <?php
        ?>
        <form action="options.php" method="post">
            <?php

            settings_errors();
            settings_fields('my_order_status');
            ?>
            <div class="rafasshop-setting-sections">
                <?php do_settings_sections('pod-reo'); ?>
            </div>
            <div class="rafasshop-setting-sections">
                <?php do_settings_sections('pod-reo-distance-section'); ?>
                <p class="notice-message"><?php _e('This is the default distance to start printing from the top for all the designs/products in this store. Can be overridden individually in each product variation.', 'wc_reo'); ?></p>
                <p><a class="document-link" href="https://www.rafasshop.es/especificar-la-posicion-del-diseno/" target="_blank"><?php _e('More info', 'wc_reo' ); ?></a></p>
            </div>
            <div class="rafasshop-setting-sections">
                <?php do_settings_sections('pod-reo-printing-method-section'); ?>
                <p class="notice-message"><?php _e('<b>NOTE:</b> This is the default printing method for all the products in the store. If you want to print in different printing methods some designs/products, you can select different options in the product variation.', 'wc_reo'); ?></p>
                <p class="notice-message"><?php _e('<b>VERY IMPORTANT:</b> For dropshipping we always use the "direct print" method. If you want to use different printing methods, please, contact us to see your exact needs and based on your designs, selected products, etc.', 'wc_reo'); ?></p>
            </div>
                <p><a class="document-link" href="https://www.rafasshop.es/plugin-dropshipping-woocommerce-rafasshop-pod/" target="_blank"><?php _e( 'Documentation and Help', 'wc_reo'); ?></a></p>
                <?php
                submit_button();
            ?>
        </form>
    </div>
<?php
}

function rafasshopDefaultPrintingMethods(){
    $default_printing_methods = array(
                            ''              => 'Select Printing Method',
                            'direct_print'  => 'Direct Print',
                            'dtf'           => 'DTF',
                            'embroidery'    => 'Embroidery',
                            'vinyl'         => 'Vinyl',
                            'sublimation'   => 'Sublimation',
                            'silkscreen'    => 'Silkscreen'
                        );
    return $default_printing_methods;
}