<?php

defined('ABSPATH') or die('No script kiddies please!');

/**
 * General custom fields for woocommerce products.
 */

// Display Fields
add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields');


// Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save');

function woocommerce_product_custom_fields()
{
    global $woocommerce, $post;
    echo '<div class="product_custom_field">';
    
    if(get_option('rafasshop_product_selection') != 'rafasshop_product' ){
        echo '<div class="block-sep blc1">';
        
        woocommerce_wp_checkbox(
        array(
          'id'            => 'is_rafasshop_product',
          'label'         => __('Rafasshop product','wc_reo' )
             )
        );
        
        echo '</div>';
    }
    
    echo '<div class="block-sep blc2">';
    // Custom Product Text Field for rafasshop sku
    $args_rafasshop_sku = array(
        'id' => 'general_rafasshop_sku',
        'placeholder' => 'Rafasshop SKU',
        'label' => __('Rafasshop SKU', 'wc_reo'),
        'desc_tip' => 'true',
    );
    if(get_option('product_sku_as_rafasshop') == 1 || get_post_meta($post->ID,'general_product_sku_as_rafasshop','true') == 'yes'){
        $args_rafasshop_sku['custom_attributes'] = array('readonly' => 'readonly','disabled' => 'disabled');
    }
    
    woocommerce_wp_text_input($args_rafasshop_sku);

    if(get_option('product_sku_as_rafasshop') != 1){
        woocommerce_wp_checkbox(
        array(
          'id'            => 'general_product_sku_as_rafasshop',
          'label'         => __('Use SKU of this variation (must match with Rafasshop SKU)','wc_reo' )
             )
        );        
    }
    
    // END: Custom Product Text Field for rafasshop sku
    echo '</div>';

/**
 * Media to print url: Front side
 */
    echo '<div class="block-sep blc3">';
    woocommerce_wp_text_input(
        array(
            'id' => 'general_media_to_print_url',
            'placeholder' => 'https://',
            'label' => __('Front Media to print URL (Allowed filetype: PNG)', 'wc_reo'),
            'desc_tip' => 'true',
        )
    );

    $upload_image = get_post_meta($post->ID,'general_media_to_print_url',true) ? get_post_meta($post->ID,'general_media_to_print_url',true) : "";
    $general_design_number = get_post_meta($post->ID,'general_design_number',true) ? get_post_meta($post->ID,'general_design_number',true) : "";
    if($upload_image){
    ?>
        <button id="set_custom_images"><?php _e( 'Upload Front media', 'wc_reo' ); ?></button>
        <span id="set_custom_images_error" class="rafasshop-required" style="display:none"><?php _e('please select .png image file.','wc_reo');?></span>
        <img src="<?php echo $upload_image; ?>" alt="" width="50" id="preview-custom-image" />
        <a href="javascript:void(0)" class="remove-front-media"><?php _e('remove','wc_reo');?></a>

    <?php
    }
    else{
    ?>
        <button id="set_custom_images"><?php _e( 'Upload Front media', 'wc_reo' ); ?></button>
        <span id="set_custom_images_error" class="rafasshop-required" style="display:none"><?php _e('please select .png image file.','wc_reo');?></span>
        <img src="" width="50" alt="" id="preview-custom-image" />
    <?php
    }
/** END: Front Media to print url */
    

/**
 * Product default url for preview: Front side.
 */
    $checkbox_for_preview = get_post_meta( $post->ID, 'general_product_default_image_for_url', true );
    if($checkbox_for_preview == "yes"){
        $checkbox_checked = "checked";
        $style_display_box = "style='display:none'";
    }
    else{
        $checkbox_checked = "";
        $style_display_box = "";
    }

    ?> 

<?php
woocommerce_wp_checkbox(
    array(
      'id'            => 'general_product_default_image_for_url',
      'label'         => __('Use product default image for URL of preview design','wc_reo' )
         )
    );
?>
<div id="general_thumbnail_preview_block" <?php echo $style_display_box;?>>
<?php
    
    woocommerce_wp_text_input(
        array(
            'id' => 'general_thumbnail_preview_url',
            'placeholder' => 'https://',
            'label' => __('Front Thumbnail preview url (Allowed filetype: JPEG)', 'wc_reo'),
            'desc_tip' => 'true',
        )
    );

    $upload_image = get_post_meta($post->ID,'general_thumbnail_preview_url',true);
    if($upload_image){
    ?>
        <button id="thumbnail_preview_url"><?php _e( 'Upload Front thumbnail', 'wc_reo' ); ?></button>
        <span id="thumbnail_preview_url_error" class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>
        <img src="<?php echo $upload_image; ?>" alt="" width="50" id="thumbnail_preview-custom-image" />
        <a href="javascript:void(0)" class="remove-front-thumbnail"><?php _e('remove','wc_reo');?></a>
    <?php
    }
    else{
    ?>
        <button id="thumbnail_preview_url"><?php _e( 'Upload Front thumbnail', 'wc_reo' ); ?></button>
        <span id="thumbnail_preview_url_error" class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>
        <img src="" width="50" alt="" id="thumbnail_preview-custom-image" />
    <?php
    }
    echo'</div>';

    echo '</div>';
/** END: Product default url for preview: Front side */


/**
 * Back Media to print url
 */
    echo '<div class="block-sep blc4">';
    woocommerce_wp_text_input(
        array(
            'id' => 'general_media_to_print_url_back_side',
            'placeholder' => 'https://',
            'label' => __('Back Media to print URL (Allowed filetype: PNG)', 'wc_reo'),
            'desc_tip' => 'true',
        )
    );

    $upload_image_back_side = get_post_meta($post->ID,'general_media_to_print_url_back_side',true) ? get_post_meta($post->ID,'general_media_to_print_url_back_side',true) : "";
    if($upload_image_back_side){
    ?>
        <button id="set_custom_images_back_side"><?php _e( 'Upload Back media', 'wc_reo' ); ?></button>
        <span id="set_custom_images_back_side_error" class="rafasshop-required" style="display:none"><?php _e('please select .png image file.','wc_reo');?></span>
        <img src="<?php echo $upload_image_back_side; ?>" alt="" width="50" id="preview-custom-image-back-side" />
        <a href="javascript:void(0)" class="remove-back-media"><?php _e('remove','wc_reo');?></a>
    <?php
    }
    else{
    ?>
        <button id="set_custom_images_back_side"><?php _e( 'Upload Back media', 'wc_reo' ); ?></button>
        <span id="set_custom_images_back_side_error" class="rafasshop-required" style="display:none"><?php _e('please select .png image file.','wc_reo');?></span>
        <img src="" width="50" alt="" id="preview-custom-image-back-side" />
    <?php
    }
/** END: Back Media to print url */
    
    
/**
 * Product default url for preview: Back side.
 */
    $checkbox_for_preview = get_post_meta( $post->ID, 'general_product_default_image_for_url_back_side', true );
    if($checkbox_for_preview == "yes"){
        $checkbox_checked = "checked";
        $style_display_box = "style='display:none'";
    }
    else{
        $checkbox_checked = "";
        $style_display_box = "";
    }

    ?> 

<?php
woocommerce_wp_checkbox(
    array(
      'id'            => 'general_product_default_image_for_url_back_side',
      'label'         => __('Use product default image for URL of preview design','wc_reo' )
         )
    );
?>
<div id="general_thumbnail_preview_block_back_side" <?php echo $style_display_box;?>>
<?php
    
    woocommerce_wp_text_input(
        array(
            'id' => 'general_thumbnail_preview_url_back_side',
            'placeholder' => 'https://',
            'label' => __('Back Thumbnail preview url (Allowed filetype: JPEG)', 'wc_reo'),
            'desc_tip' => 'true',
        )
    );

    $upload_image_back_side = get_post_meta($post->ID,'general_thumbnail_preview_url_back_side',true);
    if($upload_image_back_side){
    ?>
        <button id="thumbnail_preview_url_back_side"><?php _e( 'Upload Back thumbnail', 'wc_reo' ); ?></button>
        <span id="thumbnail_preview_url_back_side_error" class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>
        <img src="<?php echo $upload_image_back_side ; ?>" alt="" width="50" id="thumbnail_preview-custom-image-back-side" />
        <a href="javascript:void(0)" class="remove-back-thumbnail"><?php _e('remove','wc_reo');?></a>
    <?php
    }
    else{
    ?>
        <button id="thumbnail_preview_url_back_side"><?php _e( 'Upload Back thumbnail', 'wc_reo' ); ?></button>
        <span id="thumbnail_preview_url_back_side_error" class="rafasshop-required" style="display:none"><?php _e('please select .jpeg image file.','wc_reo');?></span>
        <img src="" width="50" alt="" id="thumbnail_preview-custom-image-back-side" />
    <?php
    }
    echo'</div>';
    echo '</div>';

/** END: Product default url for preview: back side */    
    

    
/**
 * Custom fields for Nacklabel image
 */
    echo '<div class="block-sep blc5">';
    echo '<div id="general_necklabel_preview_block">'
    ?>
    <p class="notice-message"><b><?php _e('We will use this image as your necklabel logo for this product variation. If you don\'t add any image here, we will use the provided on general settings. If you don\'t add image on general setttings, we will not print any custom necklabel.  Print custom necklabel cost: +1.95€ (Allowed filetype: PNG)','wc_reo'); ?></b></p>

    <button id="set_necklabel_image"><?php _e('Necklabel Image','wc_reo'); ?></button>
    <span class='rafasshop-required' id='necklabel-image-error' style='display:none'><?php _e('please select .png image file.','wc_reo'); ?></span>
    <?php
    $necklabel_url = get_post_meta($post->ID, 'necklabel_image_url', true); 
    if($necklabel_url != ""){
        ?>
        <img src="<?php echo $necklabel_url; ?>" alt="" width="50" id="preview-necklabel-image" />
        <a href="javascript:void(0)" class="remove-general-necklabel-media"><?php _e('remove','wc_reo');?></a>
        <input type="hidden" id="necklabel_image_url" name="necklabel_image_url" value="<?php echo $necklabel_url; ?>"  />
        
    <?php
    }
    else{
    ?>
        <img src="" alt="" width="50" id="preview-necklabel-image" />
        <input type="hidden" id="necklabel_image_url" name="necklabel_image_url" value=""  />
    <?php
    }
    echo'</div>';

    echo '</div>';
/** END: Custom fields for necklabel*/
    
    
    // Start: Distance to start printing from top in front side
    echo '<div class="block-sep blc6">';
        $args_printing_top_in_front = array(
            'id' => 'general_design_top_position_front',
            'placeholder' => '0',
            'label' => __('Distance to start printing from top in front side (cm)', 'wc_reo'),
            'type' => 'number',
            'custom_attributes' => array(
                'min' => '0',
                'max' => '99'
            )
        );

        woocommerce_wp_text_input($args_printing_top_in_front);

        $args_printing_top_in_back = array(
            'id' => 'general_design_top_position_back',
            'placeholder' => '0',
            'label' => __('Distance to start printing from top in back side (cm)', 'wc_reo'),
            'type' => 'number',
            'custom_attributes' => array(
                'min' => '0',
                'max' => '99'
            )
        );

        woocommerce_wp_text_input($args_printing_top_in_back);
        
        ?>
        <p class="notice-message"><?php _e('This is the default distance to start printing from the top for this variation. Will override the information in the general setup.', 'wc_reo'); ?></p>
        <p><a class="document-link" href="https://www.rafasshop.es/especificar-la-posicion-del-diseno/" target="_blank"><?php _e('More info', 'wc_reo' ); ?></a></p>
        <?php

    echo '</div>';
    // END: Distance to start printing from top in back side
    
    
    // Start: PRINTING METHOD
    echo '<div class="block-sep blc7">';
        $default_printing_status = rafasshopDefaultPrintingMethods();
    
        $args_printing_methods = array(
            'id' => 'general_rafasshop_printing_method',
            'label' => __('Please, select the default printing method:', 'wc_reo'),
            'options' => $default_printing_status
        );
        
        woocommerce_wp_select($args_printing_methods);
        ?>
        <p class="notice-message"><?php _e('<b>NOTE:</b> This is the printing method for this product variation, so you can select different printing method in each design/product.', 'wc_reo'); ?></p>
        <p class="notice-message"><?php _e('<b>VERY IMPORTANT:</b> For dropshipping we always use the "direct print" method. If you want to use different printing methods, please, contact us to see your exact needs and based on your designs, selected products, etc.', 'wc_reo'); ?></p>
        <?php

    echo '</div>';
    // END: PRINTING METHOD

    
echo '</div>';
}



/**
 * 
 * Save data in product post meta field.
 */
function woocommerce_product_custom_fields_save($post_id)
{
    
    $is_rafasshop_product = isset( $_POST['is_rafasshop_product'] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'is_rafasshop_product', $is_rafasshop_product );

    $rafasshop_sku = $_POST['general_rafasshop_sku'];
    if (!empty($rafasshop_sku))
        update_post_meta($post_id, 'general_rafasshop_sku', esc_attr($rafasshop_sku));
    
    $checkbox_product_sku_as_rafasshop = isset( $_POST['general_product_sku_as_rafasshop'] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'general_product_sku_as_rafasshop', $checkbox_product_sku_as_rafasshop );

    
    /* Front side upload media to print */
    $media_to_print_url = $_POST['general_media_to_print_url'];
    update_post_meta($post_id, 'general_media_to_print_url', esc_attr($media_to_print_url));
    if (!empty($media_to_print_url))
    {
        $general_design_number = pathinfo($media_to_print_url, PATHINFO_FILENAME);
        update_post_meta($post_id, 'general_design_number', esc_attr($general_design_number));
    }   

    $checkbox = isset( $_POST['general_product_default_image_for_url'] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'general_product_default_image_for_url', $checkbox );

    if(isset( $_POST['general_product_default_image_for_url'] )){

        $src = get_the_post_thumbnail_url($post_id);
        update_post_meta($post_id, 'general_thumbnail_preview_url', esc_attr( $src ));    

    }else{
        $media_to_print_url = $_POST['general_thumbnail_preview_url'];
        update_post_meta($post_id, 'general_thumbnail_preview_url', esc_attr($media_to_print_url));    
    }
    /* END: Front side upload media to print */
    
    
    /* Back side upload media to print */
    $media_to_print_url_back_side = $_POST['general_media_to_print_url_back_side'];
    update_post_meta($post_id, 'general_media_to_print_url_back_side', esc_attr($media_to_print_url_back_side));   

    $checkbox_back_side = isset( $_POST['general_product_default_image_for_url_back_side'] ) ? 'yes' : 'no';
    update_post_meta( $post_id, 'general_product_default_image_for_url_back_side', $checkbox_back_side );

    if(isset( $_POST['general_product_default_image_for_url_back_side'] )){

        $src = get_the_post_thumbnail_url($post_id);
        update_post_meta($post_id, 'general_thumbnail_preview_url_back_side', esc_attr( $src ));    

    }else{
        $thumbnail_back_to_print_url = $_POST['general_thumbnail_preview_url_back_side'];
        update_post_meta($post_id, 'general_thumbnail_preview_url_back_side', esc_attr($thumbnail_back_to_print_url));    
    }
    /* END: Back side upload media to print */


    
    $necklabel_image = $_POST['necklabel_image_url'];
    update_post_meta($post_id, 'necklabel_image_url', esc_attr($necklabel_image));

    // Start: Distance to start printing from top in front/back side
    $general_design_top_position_front = $_POST['general_design_top_position_front'];
    update_post_meta($post_id, 'general_design_top_position_front', $general_design_top_position_front);
    
    $general_design_top_position_back = $_POST['general_design_top_position_back'];
    update_post_meta($post_id, 'general_design_top_position_back', $general_design_top_position_back);
    // End: Distance to start printing from top in front/back side

    $general_rafasshop_printing_method = $_POST['general_rafasshop_printing_method'];
    update_post_meta($post_id, 'general_rafasshop_printing_method', $general_rafasshop_printing_method);
 

}
