<?php
/*
  Plugin name: Dropshipping Rafasshop
  Version: 1.0.6
  Description: Dropshipping Rafasshop
  Author: Rafasshop
  Text Domain: wc_reo
  Domain Path: /languages
 */

 defined('ABSPATH') or die('No script kiddies please!');


 set_include_path( plugin_dir_path(__FILE__).'phpseclib' );
 include( plugin_dir_path(__FILE__).'phpseclib/Net/SFTP.php');

 include( plugin_dir_path(__FILE__).'include/admin/wc-general-product-fields.php');
 include( plugin_dir_path(__FILE__).'include/admin/wc-variation-product-fields.php');
 include( plugin_dir_path(__FILE__).'include/admin/settings.php');
 


 /**
  * Admin enqueue scripts
  */
 if (!function_exists('reo_enqueue_scripts')) {

    add_action('admin_enqueue_scripts', 'reo_enqueue_scripts');

    function reo_enqueue_scripts() {    

        wp_enqueue_style('select2-style', plugin_dir_url(__FILE__) . 'assets/css/select2.min.css');

        wp_enqueue_style('custom-style', plugin_dir_url(__FILE__) . 'assets/css/style.css');

        wp_enqueue_media();

        wp_enqueue_script('select2-script', plugin_dir_url(__FILE__) . 'assets/js/select2.min.js', '' , '' , true);

        wp_enqueue_script('custom-script', plugin_dir_url(__FILE__) . 'assets/js/custom.js', '' , '' , false);

        $translate_text_array = array(
            'remove' => __('remove','wc_reo'),
            'upload_front_media' => __('Upload Front media','wc_reo'),
            'upload_front_thumbnail' => __('Upload Front thumbnail','wc_reo'),
            'upload_back_media' => __('Upload Back media','wc_reo'),
            'upload_back_thumbnail' => __('Upload Back thumbnail','wc_reo'),
            'necklabel_image' => __('Necklabel Image','wc_reo'),
        );
        wp_localize_script('custom-script', 'translate_text', $translate_text_array);
    }

}



/**
 * Load textdomain directory
 */
if (!function_exists('reo_init_data')) {

    add_action('init', 'reo_init_data');

    function reo_init_data() {

        load_plugin_textdomain('wc_reo', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }

}


/**
 * Add custom column in order listing page.
 */
add_filter( 'manage_edit-shop_order_columns', 'order_listing_add_column_podrafasshop' );

function order_listing_add_column_podrafasshop( $columns ) {
    
    $new_columns = array();
    foreach ( $columns as $column_name => $column_info ) {

        $new_columns[ $column_name ] = $column_info;

        if ( 'order_status' === $column_name ) {
            $new_columns['pod_rafasshop'] = __('POD Rafasshop','wc_reo');
        }
    }
    return $new_columns;
}


/**
 * Display message in custom added column.
 */
add_action( 'manage_shop_order_posts_custom_column', 'podrafasshop_column_content' );

function podrafasshop_column_content( $column ) {
    
    global $post;

    if ( 'pod_rafasshop' === $column ) {

        $order_id = $post->ID;

        $message = wc_get_order_item_meta($order_id,'my_status_message', true) ? wc_get_order_item_meta($order_id,'my_status_message', true) : "-";

        echo $message;

    }

}



/**
 * Display bulk action in order listing page
 */
add_filter( 'bulk_actions-edit-shop_order', 'pod_reo_bulk_actions_marked_unmarked', 20, 1 );

function pod_reo_bulk_actions_marked_unmarked( $actions ) {
    $actions['marked_to_send'] = __('Marked To Send','wc_reo');
    $actions['unmarked_to_send'] = __('Unmarked To Send','wc_reo');
    return $actions;
}



/**
 * Perform operation on custom bulk action
 */
add_filter( 'handle_bulk_actions-edit-shop_order', 'pod_reo_handle_bulk_action_marked_unmarked', 10, 3 );

function pod_reo_handle_bulk_action_marked_unmarked( $redirect_to, $action, $post_ids ) {
    
    $option_start_date = get_option('my_status_start_date');
    $option_status = get_option('my_status_select_status');
    
    // $redirect_to = remove_query_arg( array( 'marked_to_send_done', 'unmarked_to_send_done' ), $redirect_to );

    $redirect_to = remove_query_arg( array( 'rafasshop_status_updated' ), $redirect_to );

    $count = 0;

    switch($action){
        
        case 'marked_to_send':{
            foreach($post_ids as $order_id){
                
                $order = new WC_Order($order_id);
                $order_status = $order->get_status();

                $is_sent = wc_get_order_item_meta($order_id, 'my_status_message');

                if( in_array( 'wc-'.$order_status , $option_status ) && $is_sent != 'SENT' ){

                    wc_update_order_item_meta($order_id,'my_status_message','Marked to send');

                    $count++;
                }
            }
            if( $count > 0 ){
                $redirect_to = add_query_arg('rafasshop_status_updated',$redirect_to );
            }
            break;
        }

        case 'unmarked_to_send':{
            foreach($post_ids as $order_id){
                $order = new WC_Order($order_id);
                $order_status = $order->get_status();

                $is_sent = wc_get_order_item_meta($order_id, 'my_status_message');

                if( in_array( 'wc-'.$order_status , $option_status ) && $is_sent != 'SENT' ){

                    wc_update_order_item_meta($order_id,'my_status_message','Not exported before');
                    $count++;
                       
                }    
            }
            if( $count > 0 ){
                $redirect_to = add_query_arg('rafasshop_status_updated',$redirect_to );
            }
            break;
        }

    }
    return $redirect_to;
    
}



/**
 * Add admin message on bulk actions
 */
add_action( 'admin_notices', 'pod_reo_bulk_action_notices' );
 
function pod_reo_bulk_action_notices() {
 
    if ( ! empty( $_REQUEST['rafasshop_status_updated'] ) ) {
		?>
        <div id="message" class="updated notice is-dismissible">
			<p><?php _e('POD Rafasshop status updated.','wc_reo'); ?></p>
        </div>
        <?php
    }
    
}



/**
 * Add custom message when order status change
 */
add_action('woocommerce_order_status_changed', 'pod_reo_message_change_status');

function pod_reo_message_change_status($order_id) {

    $order = new WC_Order($order_id);
    $order_date = $order->get_date_created();
    $date_created = $order_date->date('Y-m-d');
    $order_status = $order->get_status();

    $option_start_date = get_option('my_status_start_date');
    $option_status = get_option('my_status_select_status');
    $option_atomatic_apply = get_option('my_status_automatic_apply_message');

    $if_sent = wc_get_order_item_meta($order_id,'my_status_message',true) ? wc_get_order_item_meta($order_id,'my_status_message',true) : "";

    if( $if_sent != 'SENT' ){
        if( in_array( 'wc-'.$order_status , $option_status ) && ($date_created >= $option_start_date) && $option_atomatic_apply ){

            wc_update_order_item_meta($order_id,'my_status_message','Marked to send');
            
        }
        else{
    
            wc_update_order_item_meta($order_id,'my_status_message','Not exported before');
    
        }
    }
    
}


add_filter( 'woocommerce_hidden_order_itemmeta', 'hide_my_item_meta' );

function hide_my_item_meta( $hidden_meta ) {
  
  $hidden_meta[] = 'my_status_message';  
  
  return $hidden_meta;

}



/**
 * Register activation hook
 */
register_activation_hook(__FILE__, 'pod_reo_plugin_activation');
function pod_reo_plugin_activation() {
}



/**
 * Register deactivation hook
 */
register_deactivation_hook(__FILE__, 'pod_reo_plugin_deactivation');
function pod_reo_plugin_deactivation(){

    add_filter('rest_endpoints', function($endpoints) {

        unset( $endpoints['/podrafasshop/csvdata'] );
        return $endpoints;
    });
    
}



/**
 * Register uninstall hook
 */
register_uninstall_hook(__FILE__, 'pod_reo_plugin_uninstall');
function pod_reo_plugin_uninstall(){
    delete_option('my_status_customer_id');
    delete_option('my_status_start_date');
    delete_option('my_status_select_status');
    delete_option('my_status_automatic_apply_messages');
    delete_option('necklabel');
    delete_option('necklabel_image_url');
    delete_option('product_sku_as_rafasshop');
    delete_option('custom_message_for_packing_list');
    delete_option('rafasshop_product_selection');
    delete_option('rafasshop_design_top_position_front');
    delete_option('rafasshop_design_top_position_back');
    delete_option('rafasshop_default_printing_methods');
}


/**
 * Rest API function that generate csv file and update order meta from marked to sent to send.
 */

add_action('rest_api_init', function(){
    register_rest_route('podrafasshop','/csvdata',array(
        'methods' => WP_REST_Server::READABLE,
        'callback' => 'generate_csv_pod_rafasshop',
        'permission_callback' => '__return_true'
    ));
});


function generate_csv_pod_rafasshop(){

    global $wpdb;

    $count = 0;
    $data = array();

    $customer_id = get_option('my_status_customer_id');
    $necklabel_image = "";
    $necklabel = get_option('necklabel');
    if($necklabel){
        $necklabel ="Yes";
        $necklabel_image = get_option('necklabel_image_url') ? get_option('necklabel_image_url') : "";
    }
    else{
        $necklabel = "No";
        $necklabel_image = "";
    }
   
    $product_sku_as_rafasshop_sku = get_option('product_sku_as_rafasshop');
    $custom_message_for_packing_list = get_option('custom_message_for_packing_list');    
    $rafasshop_product_selection = get_option('rafasshop_product_selection');

    $default_printing_status = rafasshopDefaultPrintingMethods();
    $option_rafasshop_design_top_position_front = get_option('rafasshop_design_top_position_front');
    $option_rafasshop_design_top_position_back = get_option('rafasshop_design_top_position_back');
    $option_printing_method = get_option('rafasshop_default_printing_methods') ? $default_printing_status[get_option('rafasshop_default_printing_methods')] : $default_printing_status['direct_print'];
    
    // $start_date = get_option('my_status_start_date');
    $current_date = date('Ymd');

    $order_ids = $wpdb->get_results( "SELECT order_item_id from {$wpdb->prefix}woocommerce_order_itemmeta where meta_value='Marked to send' group by order_item_id desc" , ARRAY_A);

  
    foreach($order_ids as $single_order_id){
       
        $single_order_id = $single_order_id['order_item_id'];
                
        $order = new WC_Order($single_order_id);

        $pod_order_id = 'DS-'.$customer_id.'-'.$order->get_id();
        $web_order_id = $order->get_id();

        $order_date = $order->get_date_created();
        $date_of_order = $order_date->date("Y-m-d");

        $billing_name = $order->get_formatted_shipping_full_name();
        $billing_address = "";
        if($order->get_shipping_address_1() != ""){
            $billing_address.= $order->get_shipping_address_1();
        }
        if($order->get_shipping_address_2() != ""){
            $billing_address.= ", ".$order->get_shipping_address_2();
        }

        $billing_city = $order->get_shipping_city();
        $billing_postcode = $order->get_shipping_postcode();
        $billing_state = $order->get_shipping_state();
        $billing_country = $order->get_shipping_country();
        $billing_phone = $order->get_billing_phone();
        $billing_email = $order->get_billing_email();

        $handling_folding = "Y";


        $order_items = $order->get_items();
        foreach( $order_items as $item ){    
            $product = $item->get_product();
            $product_name = $product->get_name();
            $item_quantity = $item->get_quantity();
            
            if($rafasshop_product_selection == 'rafasshop_product' || ( $rafasshop_product_selection == 'other_providers' && (get_post_meta($product->get_id(),'is_rafasshop_product',true) == 'yes'))){
                
                if( $product->is_type( 'simple' ) ) {
                    $product_id = $item->get_product_id();
                    if($product_sku_as_rafasshop_sku == 1 || get_post_meta($product_id,'general_product_sku_as_rafasshop',true) == 'yes'){
                        $rafasshop_sku = $product->get_sku();
                    }
                    else{
                        $rafasshop_sku = get_post_meta($product_id,'general_rafasshop_sku',true) ? get_post_meta($product_id,'general_rafasshop_sku',true) : "";
                    }

                    $url_image = get_post_meta($product_id,'general_media_to_print_url',true) ? get_post_meta($product_id,'general_media_to_print_url',true) : "";
                    $url_web_preview = get_post_meta($product_id,'general_thumbnail_preview_url',true) ? get_post_meta($product_id,'general_thumbnail_preview_url',true) : ""; 

                    $design_number = get_post_meta($product_id,'general_design_number',true) ? get_post_meta($product_id,'general_design_number',true) : "";

                    $customized = $url_image != "" ? "Y" : "N";

                    $back_media_image = get_post_meta($product_id,'general_media_to_print_url_back_side',true) ? get_post_meta($product_id,'general_media_to_print_url_back_side',true) : "";
                    $back_thumbnail_image = get_post_meta($product_id,'general_thumbnail_preview_url_back_side',true) ? get_post_meta($product_id,'general_thumbnail_preview_url_back_side',true) : ""; 

                    $product_nacklabel_image = get_post_meta($product_id,'necklabel_image_url',true) ? get_post_meta($product_id,'necklabel_image_url',true) : "";
                    $product_nacklabel_image != "" ? $final_necklabel = $product_nacklabel_image : $final_necklabel = $necklabel_image;
                    
                    $final_necklabel == '' ? $necklabel = 'N' : $necklabel = "Y";
                    
                    $design_top_position_front = get_post_meta($product_id,'general_design_top_position_front',true) ? get_post_meta($product_id,'general_design_top_position_front',true) : $option_rafasshop_design_top_position_front; 
                    $design_top_position_back = get_post_meta($product_id,'general_design_top_position_back',true) ? get_post_meta($product_id,'general_design_top_position_back',true) : $option_rafasshop_design_top_position_back; 
                    $printing_method = get_post_meta($product_id,'general_rafasshop_printing_method',true) ? $default_printing_status[get_post_meta($product_id,'general_rafasshop_printing_method',true)] : $option_printing_method; 
                    
                    $data[$count][] = $customer_id;
                    $data[$count][] = $pod_order_id;
                    $data[$count][] = $web_order_id;
                    $data[$count][] = $date_of_order;
                    $data[$count][] = $billing_name;
                    $data[$count][] = $billing_address;
                    $data[$count][] = $billing_city;
                    $data[$count][] = $billing_postcode;
                    $data[$count][] = $billing_state;
                    $data[$count][] = $billing_country;
                    $data[$count][] = $billing_phone;
                    $data[$count][] = $billing_email;
                    $data[$count][] = "";
                    $data[$count][] = $rafasshop_sku;
                    $data[$count][] = $item_quantity;
                    $data[$count][] = $design_number;
                    $data[$count][] = $url_image;
                    $data[$count][] = $url_web_preview;
                    $data[$count][] = $product_name;
                    $data[$count][] = $necklabel;
                    $data[$count][] = $handling_folding;
                    $data[$count][] = $customized;
                    $data[$count][] = $final_necklabel;
                    $data[$count][] = $back_media_image;
                    $data[$count][] = $back_thumbnail_image;
                    $data[$count][] = $custom_message_for_packing_list;
                    $data[$count][] = $design_top_position_front;
                    $data[$count][] = $design_top_position_back;
                    $data[$count][] = $printing_method;

                    $count++;
                }
                else{
                    $variation_id = $item->get_variation_id();
                    $variation_product = wc_get_product($variation_id);

                    if($product_sku_as_rafasshop_sku == 1 || get_post_meta($variation_id,'variation_product_sku_as_rafasshop',true) == 'yes'){
                        $rafasshop_sku = $variation_product->get_sku();
                    }
                    else{
                        $rafasshop_sku = get_post_meta($variation_id,'rafasshop_sku',true) ? get_post_meta($variation_id,'rafasshop_sku',true) : "";
                    }                

                    $url_image = get_post_meta($variation_id,'media_to_print_url',true) ? get_post_meta($variation_id,'media_to_print_url',true) : "";
                    $url_web_preview = get_post_meta($variation_id,'thumbnail_preview_url',true) ? get_post_meta($variation_id,'thumbnail_preview_url',true) : "";

                    $design_number = get_post_meta($variation_id,'design_number',true) ? get_post_meta($variation_id,'design_number',true) : "";

                    $customized = $url_image != "" ? "Y" : "N";

                    $back_media_image = get_post_meta($variation_id,'media_to_print_url_back_side',true) ? get_post_meta($variation_id,'media_to_print_url_back_side',true) : "";
                    $back_thumbnail_image = get_post_meta($variation_id,'thumbnail_preview_url_back_side',true) ? get_post_meta($variation_id,'thumbnail_preview_url_back_side',true) : "";

                    $product_nacklabel_image = get_post_meta($variation_id,'necklabel_image_url',true) ? get_post_meta($variation_id,'necklabel_image_url',true) : "";
                    $product_nacklabel_image != "" ? $final_necklabel = $product_nacklabel_image : $final_necklabel = $necklabel_image;
                    
                    $final_necklabel == '' ? $necklabel = 'N' : $necklabel = "Y";
                    
                    $design_top_position_front = get_post_meta($variation_id,'variation_design_top_position_front',true) ? get_post_meta($variation_id,'variation_design_top_position_front',true) : $option_rafasshop_design_top_position_front; 
                    $design_top_position_back = get_post_meta($variation_id,'variation_design_top_position_back',true) ? get_post_meta($variation_id,'variation_design_top_position_back',true) : $option_rafasshop_design_top_position_back; 
                    $printing_method = get_post_meta($variation_id,'rafasshop_printing_method',true) ? $default_printing_status[get_post_meta($variation_id,'rafasshop_printing_method',true)] : $option_printing_method; 
                    
                    $data[$count][] = $customer_id;
                    $data[$count][] = $pod_order_id;
                    $data[$count][] = $web_order_id;
                    $data[$count][] = $date_of_order;
                    $data[$count][] = $billing_name;
                    $data[$count][] = $billing_address;
                    $data[$count][] = $billing_city;
                    $data[$count][] = $billing_postcode;
                    $data[$count][] = $billing_state;
                    $data[$count][] = $billing_country;
                    $data[$count][] = $billing_phone;
                    $data[$count][] = $billing_email;
                    $data[$count][] = "";
                    $data[$count][] = $rafasshop_sku;
                    $data[$count][] = $item_quantity;
                    $data[$count][] = $design_number;
                    $data[$count][] = $url_image;
                    $data[$count][] = $url_web_preview;
                    $data[$count][] = $product_name;
                    $data[$count][] = $necklabel;
                    $data[$count][] = $handling_folding;
                    $data[$count][] = $customized;
                    $data[$count][] = $final_necklabel;
                    $data[$count][] = $back_media_image;
                    $data[$count][] = $back_thumbnail_image;
                    $data[$count][] = $custom_message_for_packing_list;
                    $data[$count][] = $design_top_position_front;
                    $data[$count][] = $design_top_position_back;
                    $data[$count][] = $printing_method;

                    $count++;
                }
            }
        }        
    }
    
    if( !empty($data) ){

	    $filename = plugin_dir_path(__FILE__).'csv-report/'.$customer_id.'-'.$current_date.'.csv';
	    
	    if ( file_exists( $filename ) ) {
	        unlink( $filename );
	    }

	    $file = fopen( $filename , 'w' );

	    $headers = ['Customer', 'daily order number', 'website order', 'date of order','Recipient Name', 'Recipient Address', 'Recipient City', 'Recipient Postal Code or ZIP', 'Recipient State', 'Recipient Country', 'Recipient Mobile', 'Recipient email', 'shipment observations', 'Product SKU', 'Quantity', 'Design Numbar', 'URL image', 'URL Web Previsualization', 'Product name in your web', 'Necklabel', 'Handling and Folding', 'Customized', 'Necklabel Image','Back Media to print URL', 'Back Thumbnail preview url', 'Custom message for packing list', 'design_top_position_front', 'design_top_position_back', 'printing_method'];

	    // var_dump($header);

	    fputcsv( $file, $headers,'|','"');

	    foreach($data as $row){
	        fputcsv($file,$row,'|','"');
	    }
	    
	    fclose($file);
            
            
            $ftp_status = array();            
            
	    // When server is FTP server
	    $ftp_server = 'ftp.rafasshop.es';
            $ftp_user_name = 'ZHJvcHNoaXBwaW5nX3JhZmFzc2hvcA==';
	    $ftp_user_pass = 'TVZbOWJjQyorQHoh';
            
	    $remote_file = '/'.$customer_id.'-'.$current_date.'.csv';

	    if(file_exists($filename)){

	        $conn_id = ftp_connect($ftp_server);

	        // login with username and password
	        $login_result = ftp_login($conn_id, base64_decode($ftp_user_name), base64_decode($ftp_user_pass));
                if($login_result){
                    $ftp_status['login_with_ftp'] = 'success';
                }
                else{
                    $ftp_status['login_with_ftp'] = 'fail';
                }

	        // turn passive mode on 
	        ftp_pasv($conn_id, true);

	        if (ftp_put($conn_id, $remote_file, $filename, FTP_ASCII)) {
	            unlink($filename);
	            $ftp_status['file_uploded_to_ftp'] = true;
	        } 
	        else {
	            $ftp_status['file_uploded_to_ftp'] = false;
	        }
	        
	        ftp_close($conn_id); 

	        foreach($order_ids as $single_order_id){
	            $order_id = $single_order_id['order_item_id'];
	            wc_update_order_item_meta($order_id,'my_status_message','SENT');
	        }
	    }

	    return $ftp_status;

	}
	else{
		return 'empty data!';
	}
    
}




/**
 * Plug-in is deactivated if WooCommerce is deactivate.
 */
if ( ! function_exists('woocommerce_deactivate_rafasshop_export_order') ) {

// Deactivate plug-in when woocommerce deactivating
    add_action('admin_init', 'woocommerce_deactivate_rafasshop_export_order');

    function woocommerce_deactivate_rafasshop_export_order() {

        $active_plugins = get_option('active_plugins');

        if ( in_array('woocommerce/woocommerce.php', $active_plugins) != true ) {

            deactivate_plugins(plugin_basename(__FILE__));
            add_action('admin_notices', 'rafasshop_export_order_notice_when_woocommerce_deactivate');
        }

        if ( in_array('woocommerce/woocommerce.php', $active_plugins) == true  ) {
            global $woocommerce;

            if ( version_compare($woocommerce->version, '2.3.8', ">=") != true ) {

                deactivate_plugins(plugin_basename(__FILE__));
                add_action('admin_notices', 'rafasshop_export_order_notice_woocommerce_version_upgrade');
            }
        }
    }

}

/**
 * This function display error message if WooCommerce is not active.
 */
if ( ! function_exists('rafasshop_export_order_notice_when_woocommerce_deactivate') ) {

// Install woocommerce or activate woocommerce notice
    function rafasshop_export_order_notice_when_woocommerce_deactivate() {
        ?>
        <div class="error">
            <p><?php _e('You need to install woocommerce or activate woocommerce for active Rafasshop Export Order plug-in.', 'wc_reo'); ?></p>
        </div>
        <?php
    }

}

/**
 * This function display notice of compatibility needed of WooCommerce.
 */
if ( ! function_exists('rafasshop_export_order_notice_woocommerce_version_upgrade') ) {

// Woocommerce version upgrade notice
    function rafasshop_export_order_notice_woocommerce_version_upgrade() {
        ?>
        <div class="error">
            <p><?php _e('You need to upgrade woocommerce at least 2.3.8 or higher for active Rafasshop Export Order plug-in.', 'wc_reo'); ?></p>
        </div>
        <?php
    }

}

?>